<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted' => 'Le champ :attribute doit être accepté.',
    'accepted_if' => 'Le champ :attribute doit être accepté quand :other est :value.',
    'active_url' => 'Le champ :attribute doit être une URL valide.',
    'after' => 'Le champ :attribute doit être une date postérieure à :date.',
    'after_or_equal' => 'Le champ :attribute doit être une date postérieure ou égale à :date.',
    'alpha' => 'Le champ :attribute doit contenir uniquement des lettres.',
    'alpha_dash' => 'Le champ :attribute doit contenir uniquement des lettres, des chiffres, des tirets et des underscores.',
    'alpha_num' => 'Le champ :attribute doit contenir uniquement des lettres et des chiffres.',
    'array' => 'Le champ :attribute doit être un tableau.',
    'ascii' => 'Le champ :attribute doit contenir uniquement des caractères alphanumériques et des symboles à un octet.',
    'before' => 'Le champ :attribute doit être une date antérieure à :date.',
    'before_or_equal' => 'Le champ :attribute doit être une date antérieure ou égale à :date.',
    'between' => [
        'array' => 'Le champ :attribute doit contenir entre :min et :max éléments.',
        'file' => 'Le champ :attribute doit avoir une taille entre :min et :max kilo-octets.',
        'numeric' => 'Le champ :attribute doit être compris entre :min et :max.',
        'string' => 'Le champ :attribute doit contenir entre :min et :max caractères.',
    ],
    'boolean' => 'Le champ :attribute doit être vrai ou faux.',
    'can' => 'Le champ :attribute contient une valeur non autorisée.',
    'confirmed' => 'La confirmation du champ :attribute ne correspond pas.',
    'contains' => 'Le champ :attribute ne contient pas une valeur requise.',
    'current_password' => 'Le mot de passe est incorrect.',
    'date' => 'Le champ :attribute doit être une date valide.',
    'date_equals' => 'Le champ :attribute doit être une date égale à :date.',
    'date_format' => 'Le champ :attribute doit correspondre au format :format.',
    'decimal' => 'Le champ :attribute doit avoir :decimal décimales.',
    'declined' => 'Le champ :attribute doit être refusé.',
    'declined_if' => 'Le champ :attribute doit être refusé quand :other est :value.',
    'different' => 'Les champs :attribute et :other doivent être différents.',
    'digits' => 'Le champ :attribute doit contenir :digits chiffres.',
    'digits_between' => 'Le champ :attribute doit contenir entre :min et :max chiffres.',
    'dimensions' => 'Le champ :attribute a des dimensions d\'image invalides.',
    'distinct' => 'Le champ :attribute a une valeur en double.',
    'doesnt_end_with' => 'Le champ :attribute ne doit pas se terminer par l\'une des valeurs suivantes : :values.',
    'doesnt_start_with' => 'Le champ :attribute ne doit pas commencer par l\'une des valeurs suivantes : :values.',
    'email' => 'Le champ :attribute doit être une adresse e-mail valide.',
    'ends_with' => 'Le champ :attribute doit se terminer par l\'une des valeurs suivantes : :values.',
    'enum' => 'La valeur sélectionnée pour :attribute est invalide.',
    'exists' => 'La valeur sélectionnée pour :attribute est invalide.',
    'extensions' => 'Le champ :attribute doit avoir l\'une des extensions suivantes : :values.',
    'file' => 'Le champ :attribute doit être un fichier.',
    'filled' => 'Le champ :attribute doit avoir une valeur.',
    'gt' => [
        'array' => 'Le champ :attribute doit contenir plus de :value éléments.',
        'file' => 'Le champ :attribute doit être supérieur à :value kilo-octets.',
        'numeric' => 'Le champ :attribute doit être supérieur à :value.',
        'string' => 'Le champ :attribute doit contenir plus de :value caractères.',
    ],
    'gte' => [
        'array' => 'Le champ :attribute doit contenir au moins :value éléments.',
        'file' => 'Le champ :attribute doit être supérieur ou égal à :value kilo-octets.',
        'numeric' => 'Le champ :attribute doit être supérieur ou égal à :value.',
        'string' => 'Le champ :attribute doit contenir au moins :value caractères.',
    ],
    'hex_color' => 'Le champ :attribute doit être une couleur hexadécimale valide.',
    'image' => 'Le champ :attribute doit être une image.',
    'in' => 'La valeur sélectionnée pour :attribute est invalide.',
    'in_array' => 'Le champ :attribute doit exister dans :other.',
    'integer' => 'Le champ :attribute doit être un entier.',
    'ip' => 'Le champ :attribute doit être une adresse IP valide.',
    'ipv4' => 'Le champ :attribute doit être une adresse IPv4 valide.',
    'ipv6' => 'Le champ :attribute doit être une adresse IPv6 valide.',
    'json' => 'Le champ :attribute doit être une chaîne JSON valide.',
    'list' => 'Le champ :attribute doit être une liste.',
    'lowercase' => 'Le champ :attribute doit être en minuscules.',
    'lt' => [
        'array' => 'Le champ :attribute doit contenir moins de :value éléments.',
        'file' => 'Le champ :attribute doit être inférieur à :value kilo-octets.',
        'numeric' => 'Le champ :attribute doit être inférieur à :value.',
        'string' => 'Le champ :attribute doit contenir moins de :value caractères.',
    ],
    'lte' => [
        'array' => 'Le champ :attribute ne doit pas contenir plus de :value éléments.',
        'file' => 'Le champ :attribute doit être inférieur ou égal à :value kilo-octets.',
        'numeric' => 'Le champ :attribute doit être inférieur ou égal à :value.',
        'string' => 'Le champ :attribute doit contenir au maximum :value caractères.',
    ],
    'mac_address' => 'Le champ :attribute doit être une adresse MAC valide.',
    'max' => [
        'array' => 'Le champ :attribute ne doit pas contenir plus de :max éléments.',
        'file' => 'Le champ :attribute ne doit pas être supérieur à :max kilo-octets.',
        'numeric' => 'Le champ :attribute ne doit pas être supérieur à :max.',
        'string' => 'Le champ :attribute ne doit pas contenir plus de :max caractères.',
    ],
    'max_digits' => 'Le champ :attribute ne doit pas contenir plus de :max chiffres.',
    'mimes' => 'Le champ :attribute doit être un fichier de type : :values.',
    'mimetypes' => 'Le champ :attribute doit être un fichier de type : :values.',
    'min' => [
        'array' => 'Le champ :attribute doit contenir au moins :min éléments.',
        'file' => 'Le champ :attribute doit être d\'au moins :min kilo-octets.',
        'numeric' => 'Le champ :attribute doit être au moins :min.',
        'string' => 'Le champ :attribute doit contenir au moins :min caractères.',
    ],
    'min_digits' => 'Le champ :attribute doit contenir au moins :min chiffres.',
    'missing' => 'Le champ :attribute doit être absent.',
    'missing_if' => 'Le champ :attribute doit être absent quand :other est :value.',
    'missing_unless' => 'Le champ :attribute doit être absent sauf si :other est :value.',
    'missing_with' => 'Le champ :attribute doit être absent quand :values est présent.',
    'missing_with_all' => 'Le champ :attribute doit être absent quand :values sont présents.',
    'multiple_of' => 'Le champ :attribute doit être un multiple de :value.',
    'not_in' => 'La valeur sélectionnée pour :attribute est invalide.',
    'not_regex' => 'Le format du champ :attribute est invalide.',
    'numeric' => 'Le champ :attribute doit être un nombre.',
    'password' => [
        'letters' => 'Le champ :attribute doit contenir au moins une lettre.',
        'mixed' => 'Le champ :attribute doit contenir au moins une lettre majuscule et une lettre minuscule.',
        'numbers' => 'Le champ :attribute doit contenir au moins un chiffre.',
        'symbols' => 'Le champ :attribute doit contenir au moins un symbole.',
        'uncompromised' => 'Le :attribute fourni est apparu dans une fuite de données. Veuillez choisir un autre :attribute.',
    ],
    'present' => 'Le champ :attribute doit être présent.',
    'present_if' => 'Le champ :attribute doit être présent quand :other est :value.',
    'present_unless' => 'Le champ :attribute doit être présent sauf si :other est :value.',
    'present_with' => 'Le champ :attribute doit être présent quand :values est présent.',
    'present_with_all' => 'Le champ :attribute doit être présent quand :values sont présents.',
    'prohibited' => 'Le champ :attribute est interdit.',
    'prohibited_if' => 'Le champ :attribute est interdit quand :other est :value.',
    'prohibited_unless' => 'Le champ :attribute est interdit sauf si :other est dans :values.',
    'prohibits' => 'Le champ :attribute interdit la présence de :other.',
    'regex' => 'Le format du champ :attribute est invalide.',
    'required' => 'Le champ :attribute est obligatoire.',
    'required_array_keys' => 'Le champ :attribute doit contenir des entrées pour : :values.',
    'required_if' => 'Le champ :attribute est obligatoire quand :other est :value.',
    'required_if_accepted' => 'Le champ :attribute est obligatoire quand :other est accepté.',
    'required_if_declined' => 'Le champ :attribute est obligatoire quand :other est refusé.',
    'required_unless' => 'Le champ :attribute est obligatoire sauf si :other est dans :values.',
    'required_with' => 'Le champ :attribute est obligatoire quand :values est présent.',
    'required_with_all' => 'Le champ :attribute est obligatoire quand :values sont présents.',
    'required_without' => 'Le champ :attribute est obligatoire quand :values n\'est pas présent.',
    'required_without_all' => 'Le champ :attribute est obligatoire quand aucun de :values n\'est présent.',
    'same' => 'Le champ :attribute doit correspondre à :other.',
    'size' => [
        'array' => 'Le champ :attribute doit contenir :size éléments.',
        'file' => 'Le champ :attribute doit être de :size kilo-octets.',
        'numeric' => 'Le champ :attribute doit être :size.',
        'string' => 'Le champ :attribute doit contenir :size caractères.',
    ],
    'starts_with' => 'Le champ :attribute doit commencer par l\'une des valeurs suivantes : :values.',
    'string' => 'Le champ :attribute doit être une chaîne de caractères.',
    'timezone' => 'Le champ :attribute doit être un fuseau horaire valide.',
    'unique' => 'Le :attribute a déjà été pris.',
    'uploaded' => 'Le chargement du :attribute a échoué.',
    'uppercase' => 'Le champ :attribute doit être en majuscules.',
    'url' => 'Le champ :attribute doit être une URL valide.',
    'ulid' => 'Le champ :attribute doit être un ULID valide.',
    'uuid' => 'Le champ :attribute doit être un UUID valide.',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'users' => [
            'invalid' => 'La valeur du champ :attribute est invalide.',
            'format' => 'La valeur du champ {$attribute} n\'est pas correctement formatée.',
        ],
        'prohibited_without' => 'Le champ :attribute est interdit quand :values n\'est pas présent.',
        'mobile_number' => 'Le champ :attribute est invalide.',
        'coupon' => 'Le champ :attribute est invalide.',
        'recaptcha' => 'La vérification du captcha a échoué ! Veuillez réessayer.',
        'delay' => [
            'invalid' => 'Le champ :attribute est invalide.',
            'range' => 'Le champ :attribute doit être compris entre 0 et 120.',
        ],
        'exists_and_authorized' => 'La valeur sélectionnée pour :attribute est invalide.|Les valeurs sélectionnées pour :attribute sont invalides.',
        'contact_list_not_empty' => 'Le champ :attribute n\'a pas d\'abonnés actifs !',
        'mms_attachment_url' => [
            'invalid' => 'Le champ :attribute est invalide.',
            'file_type' => 'Le champ :attribute ne pointe pas vers un type de fichier autorisé.',
        ],
        'spreadsheet' => ':attribute n\'est pas un fichier tableur valide ou ne contient pas les données requises.',
        'update_file' => 'Le fichier de mise à jour est invalide.',
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' => [
        'file' => 'Fichier',
        'name' => 'Nom',
        'email' => 'Adresse e-mail',
        'messages.*' => 'Message #:position',
        'response' => 'Réponse',
        'type' => 'Type',
        'attachments' => 'Pièces jointes',
        'attachments.*' => 'Pièce jointe #:position',
        'criterion' => 'Condition',
        'enabled' => 'Activé',
        'mobile_number' => 'Numéro mobile',
        'subscribed' => 'Abonné',
        'code' => 'Code',
        'discount' => 'Remise',
        'quantity' => 'Quantité',
        'expires_at' => 'Expire le',
        'label' => 'Étiquette',
        'tag' => 'Tag',
        'options.*.label' => 'Étiquette de l\'option #:position',
        'options.*.value' => 'Valeur de l\'option #:position',
        'default_value' => 'Valeur par défaut',
        'default_value.*' => 'Valeur par défaut #:position',
        'required' => 'Requis',
        'description' => 'Description',
        'price' => 'Prix',
        'interval' => 'Intervalle',
        'interval_unit' => 'Unité d\'intervalle',
        'currency' => 'Devise',
        'features.credits' => 'Crédits',
        'features.contacts' => 'Contacts',
        'features.contact_lists' => 'Listes de contacts',
        'features.devices' => 'Appareils',
        'features.sending_servers' => 'Serveurs d\'envoi',
        'features.sender_ids' => 'IDs d\'expéditeur',
        'features.templates' => 'Modèles',
        'features.webhooks' => 'Webhooks',
        'features.api_tokens' => 'Jetons API',
        'features.data_export' => 'Exportation de données',
        'driver' => 'Pilote',
        'supported_types.*' => 'Type supporté #:position',
        'rate' => 'Taux',
        'country' => 'Pays',
        'inclusive' => 'Inclusif',
        'content' => 'Contenu',
        'url' => 'URL',
        'secret' => 'Secret',
        'events.*' => 'Événement #:position',
        'sims' => 'Cartes SIM',
        'sims.*' => 'Carte SIM #:position',
        'sender_ids' => 'IDs d\'expéditeur',
        'sender_ids.*' => 'ID d\'expéditeur #:position',
        'recipients' => 'Destinataires',
        'mobile_numbers' => 'Numéros mobiles',
        'mobile_numbers.*' => 'Numéro mobile #:position',
        'spreadsheet' => 'Feuille de calcul',
        'contact_lists' => 'Listes de contacts',
        'contact_lists.*' => 'Liste de contacts #:position',
        'message' => 'Message',
        'delivery_report' => 'Rapport de livraison',
        'delay' => 'Délai',
        'prioritize' => 'Prioriser',
        'scheduled_at' => 'Programmé pour',
        'ussd_codes.*' => 'Code USSD #:position',
        'users' => 'Utilisateurs',
        'timezone' => 'Fuseau horaire',
        'recurring' => 'Récurrent',
        'frequency' => 'Fréquence',
        'frequency_unit' => 'Unité de fréquence',
        'ends_at' => 'Se termine le',
        'days_of_week' => 'Jours de la semaine',
        'days_of_week.*' => 'Jour de la semaine #:position',
        'active_hours' => 'Heures actives',
        'active_hours.start' => 'Début des heures actives',
        'active_hours.end' => 'Fin des heures actives',
        'value' => 'Valeur',
        'first_name' => 'Prénom',
        'last_name' => 'Nom',
        'company' => 'Entreprise',
        'city' => 'Ville',
        'address_line_1' => 'Adresse ligne 1',
        'address_line_2' => 'Adresse ligne 2',
        'state' => 'État/Province',
        'postal_code' => 'Code postal',
        'phone' => 'Téléphone',
        'payment_method' => 'Méthode de paiement',
        'coupon' => 'Coupon',
        'guest' => 'Invité',
        'member' => 'Membre',
        'billing_info' => 'Informations de facturation',
        'recaptcha.site_key' => 'Clé de site reCAPTCHA',
        'recaptcha.secret_key' => 'Clé secrète reCAPTCHA',
        'logo' => 'Logo',
        'app' => 'Application Android',
        'mailer' => 'Système d\'e-mail',
        'sendmail.path' => 'Chemin Sendmail',
        'smtp.host' => 'Hôte',
        'smtp.port' => 'Port',
        'smtp.encryption' => 'Chiffrement',
        'smtp.username' => 'Nom d\'utilisateur',
        'smtp.password' => 'Mot de passe',
        'mailgun.domain' => 'Domaine',
        'mailgun.secret' => 'Secret',
        'mailgun.endpoint' => 'Point de terminaison',
        'ses.key' => 'Clé',
        'ses.secret' => 'Secret',
        'ses.region' => 'Région',
        'postmark.token' => 'Jeton',
        'reset_at' => 'Réinitialisé le',
        'update' => 'Mise à jour',
        'device.model' => 'Modèle',
        'device.battery' => 'Batterie',
        'device.is_charging' => 'En charge',
        'device.android_version' => 'Version Android',
        'device.sdk_version' => 'Version SDK',
        'device.app_version' => 'Version de l’application',
        'device.app_version_code' => 'Code de version de l’application',
        'device.sims.*.name' => 'Nom',
        'device.sims.*.number' => 'Numéro de mobile',
        'device.sims.*.carrier' => 'Opérateur',
        'device.sims.*.country' => 'Pays',
        'device.sims.*.icc_id' => 'ICCID',
        'device.sims.*.mcc' => 'Code pays mobile (MCC)',
        'device.sims.*.mnc' => 'Code réseau mobile (MNC)',
        'device.sims.*.data_roaming' => 'Itinérance des données',
        'device.sims.*.signal_strength' => 'Puissance du signal',
        'device.sims.*.slot' => 'Emplacement',
        'device.sims.*.active'  => 'Actif',
    ],

];
