<?php

return [
    'page' => [
        'auto_responder' => 'Auto Responder',
        'blacklist' => 'Blacklist',
        'call_log' => 'Call Log',
        'dashboard' => 'Dashboard',
        'devices' => 'Devices',
        'sending_servers' => 'Sending Servers',
        'campaigns' => 'Campaigns',
        'messages' => 'Messages',
        'ussd_pulls' => 'USSD Pulls',
        'fields' => 'Manage Fields',
        'contact_lists' => 'Contact Lists',
        'contacts' => 'Contacts',
        'coupons' => 'Coupons',
        'send_messages' => 'Send Messages',
        'payments' => 'Payments',
        'plans' => 'Plans',
        'sender_ids' => 'Sender IDs',
        'general' => 'General',
        'mail' => 'Mail',
        'webhooks' => 'Webhooks',
        'webhook_calls' => 'Webhook Calls',
        'payment_gateway' => 'Payment Gateway',
        'misc' => 'Miscellaneous',
        'settings' => 'Settings',
        'subscriptions' => 'Subscriptions',
        'taxes' => 'Taxes',
        'templates' => 'Templates',
        'sims' => 'SIMs',
        'users' => 'Users',
        'send_ussd_pulls' => 'Send USSD Pulls',
        'checkout' => 'Checkout',
        'subscribe' => 'Subscribe',
        'api_tokens' => 'API Tokens',
        'secure_area' => 'Secure Area',
        'forgot_password' => 'Forgot Password',
        'login' => 'Log In',
        'register' => 'Register',
        'reset_password' => 'Reset Password',
        'two_factor_confirmation' => 'Two Factor Confirmation',
        'email_verification' => 'Email Verification',
        'profile' => 'Profile',
        'send' => 'Send',
        'user_settings' => 'User Settings',
        'system' => 'System',
        'help' => 'Help',
    ],
    'entity' => [
        'campaign' => 'Campaign',
        'device' => 'Device',
        'sending_server' => 'Sending Server',
        'sim' => 'SIM',
        'sender_id' => 'Sender ID',
        'plan' => 'Plan',
        'quota' => 'Quota',
        'user' => 'User',
    ],
    'field' => [
        'messages' => 'Messages',
        'response' => 'Response',
        'type' => 'Type',
        'attachments' => 'Attachments',
        'criterion' => 'Condition',
        'enabled' => 'Enabled',
        'message' => 'Message',
        'mobile_numbers' => 'Mobile Numbers',
        'created_at' => 'Created At',
        'phone_number' => 'Phone Number',
        'duration' => 'Duration',
        'started_at' => 'Started At',
        'status' => 'Status',
        'statuses' => 'Statuses',
        'model' => 'Model',
        'name' => 'Name',
        'timezone' => 'Timezone',
        'frequency' => 'Frequency',
        'frequency_unit' => 'Frequency Unit',
        'ends_at' => 'Ends At',
        'active_hours' => 'Active Hours',
        'days_of_week' => 'Days of Week',
        'scheduled_at' => 'Scheduled At',
        'after' => 'After',
        'before' => 'Before',
        'id' => 'ID',
        'label' => 'Label',
        'value' => 'Value',
        'tag' => 'Tag',
        'options' => 'Options',
        'default_value' => 'Default Value',
        'required' => 'Required',
        'updated_at' => 'Updated At',
        'mobile_number' => 'Mobile Number',
        'subscribed' => 'Subscribed',
        'code' => 'Code',
        'discount' => 'Discount',
        'quantity' => 'Quantity',
        'redeemed' => 'Redeemed',
        'expires_at' => 'Expires At',
        'android_version' => 'Android Version',
        'app_version' => 'App Version',
        'battery' => 'Battery',
        'charging' => 'Charging',
        'shared_with' => 'Shared With',
        'sender_ids' => 'Sender IDs',
        'sims' => 'SIMs',
        'recipients' => 'Recipients',
        'spreadsheet' => 'Spreadsheet',
        'contact_lists' => 'Contact Lists',
        'template' => 'Template',
        'delay' => 'Delay',
        'delivery_report' => 'Delivery Report',
        'prioritize' => 'Prioritize',
        'schedule' => 'Schedule',
        'recurring' => 'Recurring',
        'sender/receiver' => 'Sender/Receiver',
        'transaction_id' => 'Transaction ID',
        'method' => 'Method',
        'amount' => 'Amount',
        'currency' => 'Currency',
        'due_date' => 'Due Date',
        'description' => 'Description',
        'interval' => 'Interval',
        'interval_unit' => 'Interval Unit',
        'price' => 'Price',
        'position' => 'Position',
        'credits' => 'Credits',
        'contacts' => 'Contacts',
        'devices' => 'Devices',
        'sending_servers' => 'Sending Servers',
        'templates' => 'Templates',
        'webhooks' => 'Webhooks',
        'api_tokens' => 'API Tokens',
        'data_export' => 'Data Export',
        'reset_at' => 'Reset At',
        'driver' => 'Gateway',
        'supported_types' => 'Supported Types',
        'available' => 'Available',
        'configurations' => 'Configurations',
        'guest' => 'Guest',
        'member' => 'Member',
        'logo' => 'Logo (512x512 px)',
        'show_captcha' => 'Show Captcha',
        'email' => 'Email',
        'mailer' => 'Mailer',
        'webhook_url' => 'Webhook URL',
        'tries' => 'Tries',
        'timeout' => 'Timeout (in seconds)',
        'verify_ssl_webhook' => 'Verify SSL certificate of the webhook receiver',
        'country' => 'Country',
        'carrier' => 'Carrier',
        'slot' => 'Slot',
        'active' => 'Active',
        'payment_method' => 'Payment Method',
        'renewal_at' => 'Renewal At',
        'rate' => 'Rate',
        'inclusive' => 'Inclusive',
        'content' => 'Content',
        'codes' => 'Codes',
        'received_at' => 'Received At',
        'url' => 'URL',
        'event' => 'Event',
        'status_code' => 'Status Code',
        'attempts' => 'Attempts',
        'last_retry_at' => 'Last Retry At',
        'payload' => 'Payload',
        'events' => 'Events',
        'billing_information' => 'Billing Information',
        'first_name' => 'First Name',
        'last_name' => 'Last Name',
        'company' => 'Company',
        'address_line_1' => 'Address Line 1',
        'address_line_2' => 'Address Line 2',
        'city' => 'City',
        'state' => 'State',
        'postal_code' => 'Postal Code',
        'users' => 'Users',
        'sent_at' => 'Sent At',
        'password' => 'Password',
        'permissions' => 'Permissions',
        'license_code' => 'License Code',
        'remember_me' => 'Remember Me',
        'confirm_password' => 'Confirm Password',
        'recovery_code' => 'Recovery Code',
        'current_password' => 'Current Password',
        'new_password' => 'New Password',
        'photo' => 'Photo',
        'tos_and_privacy_policy' => 'I agree to the :terms and :policy.',
        'feature' => 'Feature',
        'additional' => 'Additional',
        'host' => 'Host',
        'port' => 'Port',
        'username' => 'Username',
        'received' => 'Received Message',
        'sms' => 'SMS',
        'mms' => 'MMS',
        'ussd_pull' => 'USSD Pull',
        'call' => 'Call',
        'webhook_call' => 'Webhook Call',
        'per_part' => 'Per Part',
        'app' => 'Android Application',
        'service_account_json' => 'Firebase Service Account JSON',
        'message_to_email' => 'Message to Email',
        'plan' => 'Plan',
        'days' => 'Days',
        'footer' => 'Message Footer',
        'secret' => 'Secret',
        'billing-info' => 'Billing Information',
        'invoice_date' => 'Invoice Date',
        'bill_to' => 'Bill To',
        'total' => 'Total',
        'invoice' => 'Invoice',
        'realtime_dashboard' => 'Realtime Dashboard',
        'blacklist' => 'Blacklist',
        'whitelist' => 'Whitelist',
        'subscribe' => 'Subscribe',
        'unsubscribe' => 'Unsubscribe',
        'max' => 'Max',
        'change_after' => 'Change SIM or Sender ID After',
        'lifespan' => 'Lifespan (Seconds)',
        'command' => 'Command',
        'last_executed_at' => 'Last Executed At',
        'signal_strength' => 'Signal Strength',
        'password_confirmation' => 'Password Confirmation',
        'show_homepage' => 'Show Homepage',
        'queue_up' => 'Queue up long running operations',
        'resume_at' => 'Resume At',
        'version' => 'Version',
        'update' => 'Update',
        'from' => 'From',
        'protocol' => 'Protocol',
        'encryption' => 'Encryption',
        'validate_cert' => 'Validate Certificate',
        'email_to_message' => 'Email to Message',
        'cycles' => 'Cycles',
        'auto_responses' => 'Auto Responses',
        'quota' => 'Quota',
        'earnings' => 'Earnings',
        'answered' => 'Answered',
        'notify' => 'Notify',
        'option' => [
            'match' => 'Match',
            'match_case' => 'Match Case',
            'contains' => 'Contains',
            'regex' => 'Regex',
            'incoming' => 'Incoming',
            'outgoing' => 'Outgoing',
            'missed' => 'Missed',
            'voicemail' => 'Voicemail',
            'rejected' => 'Rejected',
            'blocked' => 'Blocked',
            'answered_externally' => 'Answered Externally',
            'pending' => 'Pending',
            'queued' => 'Queued',
            'processing' => 'Processing',
            'processed' => 'Processed',
            'scheduled' => 'Scheduled',
            'stalled' => 'Stalled',
            'received' => 'Received',
            'sent' => 'Sent',
            'delivered' => 'Delivered',
            'completed' => 'Completed',
            'succeeded' => 'Succeeded',
            'failed' => 'Failed',
            'sunday' => 'Sunday',
            'monday' => 'Monday',
            'tuesday' => 'Tuesday',
            'wednesday' => 'Wednesday',
            'thursday' => 'Thursday',
            'friday' => 'Friday',
            'saturday' => 'Saturday',
            'minute' => 'Minute',
            'hour' => 'Hour',
            'day' => 'Day',
            'week' => 'Week',
            'month' => 'Month',
            'year' => 'Year',
            'refunded' => 'Refunded',
            'reversed' => 'Reversed',
            'cancelled' => 'Cancelled',
            'active' => 'Active',
            'trial' => 'Trial',
            'suspended' => 'Suspended',
            'expired' => 'Expired',
            'success' => 'Success',
            'permanently_failed' => 'Permanently Failed',
            'cancelling' => 'Cancelling',
            'great' => 'Great',
            'good' => 'Good',
            'moderate' => 'Moderate',
            'poor' => 'Poor',
            'none_or_unknown' => 'None or Unknown',
        ],
    ],
    'action' => [
        'add' => 'Add',
        'create' => 'Create',
        'edit' => 'Edit',
        'save' => 'Save',
        'cancel' => 'Cancel',
        'delete' => 'Delete',
        'attach' => 'Attach',
        'retry' => 'Retry',
        'no' => 'No',
        'yes' => 'Yes',
        'show' => 'Show',
        'download_log' => 'Download Log',
        'refresh' => 'Refresh',
        'export' => 'Export',
        'import' => 'Import',
        'download' => 'Download',
        'export_again' => 'Export Again',
        'import_another' => 'Import Another',
        'share' => 'Share',
        'close' => 'Close',
        'upload' => 'Upload',
        'send' => 'Send',
        'select_visible' => 'Select Visible',
        'select_all' => 'Select All',
        'deselect_all' => 'Deselect All',
        'bulk_actions' => 'Actions',
        'next' => 'Next',
        'previous' => 'Previous',
        'approve' => 'Approve',
        'decline' => 'Decline',
        'view_invoice' => 'View Invoice',
        'new_logo' => 'Select a New Logo',
        'remove_logo' => 'Remove Logo',
        'impersonate' => 'Impersonate',
        'clear' => 'Clear',
        'apply' => 'Apply',
        'buy_now' => 'Buy Now',
        'confirm' => 'Confirm',
        'email_password_reset_link' => 'Email Password Reset Link',
        'login' => 'Log in',
        'register' => 'Register',
        'reset_password' => 'Reset Password',
        'use_recovery_code' => 'Use a recovery code',
        'use_code' => 'Use an authentication code',
        'resend_verification_email' => 'Resend Verification Email',
        'logout' => 'Log Out',
        'delete_account' => 'Delete Account',
        'logout_other_browser_sessions' => 'Log Out Other Browser Sessions',
        'enable' => 'Enable',
        'regenerate_recovery_codes' => 'Regenerate Recovery Codes',
        'show_recovery_codes' => 'Show Recovery Codes',
        'disable' => 'Disable',
        'new_photo' => 'Select A New Photo',
        'remove_photo' => 'Remove Photo',
        'subscribe' => 'Subscribe',
        'start' => 'Start',
        'remove' => 'Remove',
        'leave_impersonation' => 'Leave Impersonation',
        'show_logs' => 'Show Logs',
        'test' => 'Test',
        'ok' => 'OK',
        'assign' => 'Assign',
        'cancel_immediately' => 'Cancel Immediately',
        'docs' => 'Docs',
    ],
    'message' => [
        'auto_responder' => [
            'action' => [
                'edit' => 'Edit, Auto Response #:id',
                'delete' => 'Delete, Auto Response #:id',
            ],
            'add' => 'Add Auto Response',
            'edit' => 'Edit Auto Response',
            'delete' => 'Delete Auto Response',
            'message' => 'Message #:position',
            'add_message' => 'Add Message',
            'delete_message' => 'Delete, Message #:position',
            'delete_confirmation' => 'Are you sure you want to delete this Auto Response?',
        ],
        'blacklist' => [
            'add' => 'Add Mobile Numbers to Blacklist',
            'delete' => 'Remove a Mobile Number from Blacklist|Remove Mobile Numbers from Blacklist',
            'delete_confirmation' => 'Are you sure you would like to delete a selected mobile number from Blacklist?|Are you sure you would like to delete selected mobile numbers from Blacklist?',
        ],
        'call_log' => [
            'action' => [
                'send' => 'Send message to :number',
            ],
            'delete' => 'Delete a Call|Delete Calls',
            'delete_confirmation' => 'Are you sure you would like to delete a selected call?|Are you sure you would like to delete selected calls?',
        ],
        'campaign_devices' => [
            'action' => [
                'retry' => 'Retry, Campaign ":campaign" on Device ":device"',
                'cancel' => 'Cancel, Campaign ":campaign" on Device ":device"',
            ],
            'retry_confirmation' => 'Are you sure you would like to retry Campaign ":campaign" on Device ":device"?',
            'cancel_confirmation' => 'Are you sure you would like to cancel Campaign ":campaign" on Device ":device"?',
        ],
        'campaign_sending_servers' => [
            'action' => [
                'retry' => 'Retry, Campaign ":campaign" on Sending Server ":sendingServer"',
                'cancel' => 'Cancel, Campaign ":campaign" on Sending Server ":sendingServer"',
            ],
            'retry_confirmation' => 'Are you sure you would like to retry Campaign ":campaign" on Sending Server ":sendingServer"?',
            'cancel_confirmation' => 'Are you sure you would like to cancel Campaign ":campaign" on Sending Server ":sendingServer"?',
        ],
        'campaigns' => [
            'action' => [
                'dashboard' => 'Dashboard, Campaign ":campaign"',
                'devices' => 'Devices, Campaign ":campaign"',
                'sending_servers' => 'Sending Servers, Campaign ":campaign"',
                'show' => 'Show, Campaign ":campaign"',
                'edit' => 'Edit, Campaign ":campaign"',
                'retry' => 'Retry, Campaign ":campaign"',
                'cancel' => 'Cancel, Campaign ":campaign"',
            ],
            'retry' => 'Retry Campaign',
            'cancel' => 'Cancel Campaign',
            'delete' => 'Delete a Campaign|Delete Campaigns',
            'edit' => 'Edit Campaign',
            'send' => 'Send Campaign',
            'retry_confirmation' => 'Are you sure you would like to retry ":campaign" campaign?',
            'cancel_confirmation' => 'Are you sure you would like to cancel ":campaign" campaign?',
            'delete_confirmation' => 'Are you sure you would like to delete a selected campaign?|Are you sure you would like to delete selected campaigns?',
            'prioritize' => 'Do you want to send this campaign immediately, even if there is another unprioritized campaign still in queue?',
            'recurring' => 'Do you want to repeat this campaign on specified time interval?',
            'days_of_week' => 'Send this campaign only on selected days of week.',
        ],
        'fields' => [
            'action' => [
                'edit' => 'Edit, ":field" Field',
                'delete' => 'Delete, ":field" Field',
                'add_option' => 'Add Option',
                'delete_option' => 'Delete, Option #:position',
            ],
            'delete' => 'Delete Field',
            'add' => 'Add Field',
            'edit' => 'Edit Field',
            'option_label' => 'Option #:position Label',
            'option_value' => 'Option #:position Value',
            'delete_confirmation' => 'Are you sure you would like to delete ":field" field?',
        ],
        'job' => [
            'running_in_background' => ':job is running in the background, please wait…',
            'navigate_away_or_close' => 'You can navigate away or even close this page and get back later to check the progress.',
            'processed' => ':job has been processed successfully.',
            'queued' => ':job is queued for processing…',
            'failed' => ':job has failed to process, please try again later.',
            'being_cancelled' => ':job is being cancelled, please wait…',
            'progress' => 'Processed: :processed / :total records, Failures: :failures records',
        ],
        'contact_lists' => [
            'action' => [
                'send' => 'Send to Contact List ":contactList"',
                'show' => 'Show, Contact List ":contactList"',
                'delete' => 'Delete, Contact List ":contactList"',
                'manage_fields' => 'Manage, Contact List ":contactList" Fields',
            ],
            'add' => 'Add Contact List',
            'delete' => 'Delete Contact List',
            'edit' => 'Edit Contact List',
            'delete_confirmation' => 'Are you sure you would like to delete ":contactList" contact list?',
        ],
        'contacts' => [
            'action' => [
                'edit' => 'Edit, Contact ":contact"',
            ],
            'add' => 'Add Contact',
            'edit' => 'Edit Contact',
            'import_info' => 'It should have a header row containing the column names like :columns…',
            'import_finished' => 'Import another file or go to contacts page to see the result.',
            'delete' => 'Delete a Contact|Delete Contacts',
            'delete_confirmation' => 'Are you sure you would like to delete a selected contact?|Are you sure you would like to delete selected contacts?',
        ],
        'coupons' => [
            'action' => [
                'edit' => 'Edit, ":coupon" Coupon',
            ],
            'add' => 'Add Coupon',
            'edit' => 'Edit Coupon',
        ],
        'import' => [
            'cancel_confirmation' => 'Are you sure you would like to cancel the import process?',
        ],
        'devices' => [
            'action' => [
                'edit' => 'Edit, Device ":device"',
                'share' => 'Share, Device ":device"',
                'show_logs' => 'Show Logs, Device ":device"',
                'delete' => 'Delete, Device ":device"',
            ],
            'add' => 'Add Device',
            'edit' => 'Edit Device',
            'delete' => 'Delete Device',
            'logs' => 'Logs',
            'share' => 'Share Device',
            'delete_confirmation' => 'Are you sure you would like to delete device #:device?',
            'qr_code' => 'QR Code',
            'instructions' => [
                'title' => 'You can follow below steps to add your Android phone in the system.',
                'step1' => 'Download the latest version of Android app from the following link. It\'s preferable to download it directly onto your phone.',
                'step2' => 'Once the download is complete, proceed to install the app on your phone by opening the APK file you downloaded. It may ask you to allow installation of an unknown app from this source. If so, simply tap the "Allow from this source" option.',
                'step3' => 'After installation, open the app. You\'ll be prompted to grant various permissions. Simply click "Allow" or "Yes" on all prompts you receive. This will bring up the login window. Tap the "Sign in using QR code" button to scan the QR code displayed below.',
                'step4' => 'Congratulations, You successfully added your Android phone into the system. Now just click on "Send" option available in navigation menu to start sending messages or visit the USSD page to send USSD requests.',
            ],
        ],
        'send_messages' => [
            'add_footer' => 'Add Footer',
            'enter_manually' => 'Enter Manually',
            'from_spreadsheet' => 'From Spreadsheet',
            'contact_lists' => 'Contact Lists',
            'upload_spreadsheet_info' => 'It should have a column for mobile numbers with header named Mobile Number.',
            'characters' => 'Characters',
            'sms_parts' => 'SMS Parts',
            'delivery_report_question' => 'Do you want to request a delivery report for each SMS?',
            'unsubscribe_link' => 'To unsubscribe, click on the following link.
:link',
            'or' => 'OR',
            'unsubscribe_text' => 'You can reply ":unsubscribe {contact_list}" to this message to unsubscribe from the list.',
            'blacklist' => 'You can reply ":blacklist" to this message to prevent any further communication from us.'
        ],
        'messages' => [
            'group' => [
                'sim' => 'SIM #:id',
                'sender_id' => 'Sender ID #:id',
                'generic' => 'User #:user (:messageable)',
            ],
            'export' => 'Export Messages',
            'delete' => 'Delete a Message|Delete Messages',
            'delete_confirmation' => 'Are you sure you would like to delete a selected message?|Are you sure you would like to delete selected messages?',
            'retry' => 'Retry a Message|Retry Messages',
            'retry_confirmation' => 'Are you sure you would like to retry a selected message?|Are you sure you would like to retry selected messages?',
        ],
        'payments' => [
            'action' => [
                'approve' => 'Approve, Transaction ":id"',
                'decline' => 'Decline, Transaction ":id"',
                'view_invoice' => 'View, Invoice #id"'
            ],
            'approve' => 'Approve Payment',
            'decline' => 'Decline Payment',
            'approve_confirmation' => 'Are you sure you would like to approve transaction ":id"?',
            'decline_confirmation' => 'Are you sure you would like to decline transaction ":id"?',
            'delete_confirmation' => 'Are you sure you would like to delete this payment?',
        ],
        'payment' => [
            'title' => 'Payment #:transactionId',
            'summary' => 'Summary',
            'pending' => 'Your subscription is pending approval. Please make a bank transfer using following details to complete the payment.',
        ],
        'plans' => [
            'action' => [
                'edit' => 'Edit, ":plan" Plan',
            ],
            'edit' => 'Edit Plan',
            'add' => 'Add Plan',
        ],
        'sender_ids' => [
            'action' => [
                'share' => 'Share, Sender ID ":senderId"',
                'delete' => 'Delete, Sender ID ":senderId"',
            ],
            'add' => 'Add Sender ID',
            'share' => 'Share Sender ID',
            'delete' => 'Delete Sender ID',
            'delete_confirmation' => 'Are you sure you would like to delete sender id ":senderId"?',
        ],
        'sending_servers' => [
            'action' => [
                'edit' => 'Edit, Sending Server ":sendingServer"',
                'edit_quota' => 'Edit, Sending Server ":sendingServer" Quota',
                'delete' => 'Delete, Sending Server ":sendingServer"',
            ],
            'delete' => 'Delete Sending Server',
            'edit' => 'Edit Sending Server',
            'add' => 'Add Sending Server',
            'delete_confirmation' => 'Are you sure you would like to delete ":sendingServer" sending server?',
        ],
        'quota' => [
            'edit' => 'Edit Quota',
        ],
        'settings' => [
            'announcements' => [
                'title' => 'Announcements',
                'description' => 'Update announcements you want to show.',
            ],
            'billing_info' => [
                'title' => 'Billing Information',
                'description' => 'Update your billing information visible on invoices.',
            ],
            'registration' => [
                'title' => 'Registration',
                'description' => 'Update registration settings.',
            ],
            'website' => [
                'title' => 'Website Information',
                'description' => 'Update your website information and logo.',
            ],
            'from' => [
                'title' => 'From Address',
                'description' => 'Update your from name and email.',
            ],
            'mailer' => [
                'title' => 'Mailer Configuration',
                'description' => 'Update your mailer settings.',
                'test' => 'Test Mailer Configuration',
            ],
            'payment_gateway' => [
                'description' => 'Update :paymentGateway configurations.',
            ],
            'webhook' => [
                'title' => 'Webhook Configuration',
                'description' => 'Update your webhook settings.',
            ],
            'credits' => [
                'title' => 'Credits',
                'description' => 'Update your credits settings.',
            ],
            'features' => [
                'title' => 'Features',
                'description' => 'Enable or disable certain features.',
            ],
            'trial' => [
                'title' => 'Trial',
                'description' => 'Update your trial settings.',
            ],
            'prompts' => [
                'title' => 'Prompts',
                'description' => 'Update keywords used to trigger an action via received message.'
            ],
            'auto_retry' => [
                'title' => 'Auto Retry',
                'description' => 'Update auto retry configuration for campaigns.'
            ],
            'cron' => [
                'title' => 'Cron Job Configuration',
                'description' => 'Set up a cron job to execute the specified command every minute.'
            ],
            'system' => [
                'title' => 'System',
                'description' => 'Update the system to latest version.',
            ],
            'license' => [
                'title' => 'License',
                'description' => 'Update your license code.',
            ],
            'email_to_message' => [
                'title' => 'Email To Message',
                'description' => 'Update your email to message settings.',
            ],
            'qr_code' => [
                'title' => 'QR Code',
                'description' => 'Update your QR code settings.',
            ],
            'dashboard' => [
                'title' => 'Dashboard',
                'description' => 'Update which widgets are visible on your dashboard.',
            ]
        ],
        'sims' => [
            'action' => [
                'edit' => 'Edit, SIM ":sim"',
                'edit_quota' => 'Edit, SIM ":sim" Quota',
            ],
            'edit' => 'Edit SIM',
        ],
        'subscriptions' => [
            'action' => [
                'edit' => 'Edit, Subscription #:id',
                'payments' => 'Payments, Subscription #:id',
                'cancel' => 'Cancel, Subscription #:id',
            ],
            'edit' => 'Edit Subscription',
            'assign' => 'Assign Subscription',
            'cancel' => 'Cancel Subscription',
            'cancel_confirmation' => 'Are you sure you would like to cancel subscription ":id"?',
        ],
        'taxes' => [
            'action' => [
                'edit' => 'Edit, ":tax" Tax',
                'delete' => 'Delete, ":tax" Tax',
            ],
            'add' => 'Add Tax',
            'edit' => 'Edit Tax',
            'delete' => 'Delete Tax',
            'delete_confirmation' => 'Are you sure you would like to delete ":tax" tax?',
        ],
        'templates' => [
            'action' => [
                'edit' => 'Edit, ":template" Template',
                'delete' => 'Delete, ":template" Template',
            ],
            'add' => 'Add Template',
            'edit' => 'Edit Template',
            'delete' => 'Delete Template',
            'delete_confirmation' => 'Are you sure you would like to delete ":template" template?',
        ],
        'users' => [
            'action' => [
                'delete' => 'Delete, User ":user"',
                'impersonate' => 'Impersonate, User ":user"',
            ],
            'create' => 'Create User',
            'delete' => 'Delete User',
            'delete_confirmation' => 'Are you sure you would like to delete ":user" user?',
        ],
        'ussd_pulls' => [
            'delete' => 'Delete a USSD Pull|Delete USSD Pulls',
            'delete_confirmation' => 'Are you sure you would like to delete a selected USSD Pull?|Are you sure you would like to delete selected USSD Pulls?',
            'retry' => 'Retry a USSD Pull|Retry USSD Pulls',
            'retry_confirmation' => 'Are you sure you would like to retry a selected USSD Pull?|Are you sure you would like to retry selected USSD Pulls?',
        ],
        'send_ussd_pulls' => [
            'code_per_line' => 'Enter a single USSD code per line.',
        ],
        'webhook_calls' => [
            'action' => [
                'show' => 'Show, Webhook Call #:id',
                'retry' => 'Retry, Webhook Call #:id',
            ],
            'show' => 'Show Webhook Call',
            'retry' => 'Retry Webhook Call',
            'retry_confirmation' => 'Are you sure you would like to retry webhook call #:id?',
        ],
        'webhooks' => [
            'action' => [
                'edit' => 'Edit, Webhook ":webhook"',
                'delete' => 'Delete, Webhook ":webhook"',
            ],
            'add' => 'Add Webhook',
            'edit' => 'Edit Webhook',
            'delete' => 'Delete Webhook',
            'delete_confirmation' => 'Are you sure you would like to delete ":webhook" webhook?',
        ],
        'checkout' => [
            'payment' => 'Payment',
            'order' => 'Order summary',
            'items' => 'Items in your cart',
            'coupon' => 'Have a coupon?',
            'sub_total' => 'Sub Total',
            'discount' => ':rate% Discount',
            'total' => 'Total',
            'confirm_order' => 'Confirm order',
        ],
        'pricing' => [
            'title' => 'Pricing',
            'tagline' => 'Pricing plans for teams all sizes',
            'description' => 'Choose an affordable plan that’s packed with the best features for engaging your audience, creating customer loyalty, and driving sales.',
            'unlimited' => 'Unlimited',
            'cancel' => 'Cancel Subscription',
            'cancel_confirmation' => 'Are you sure you would like to cancel your subscription?',
            'downgrade' => 'Downgrade Subscription',
            'downgrade_warning' => 'Following features are used more than this plan allows. Please remove these additional data to downgrade to this plan.',
        ],
        'combobox' => [
            'search' => 'Enter one or more characters to search for more options.',
        ],
        'datatable' => [
            'no_data' => 'No data available',
            'actions' => 'Actions',
        ],
        'notification' => [
            'success' => 'Success!',
            'error' => 'Error!',
            'additional_errors' => ':error (and :count more error)|:error (and :count more errors)',
        ],
        'spreadsheet' => [
            'file' => 'Server\'s max upload file size is <strong>:size</strong>. Make sure your spreadsheet does not exceed this limit. Acceptable file types are CSV, XLX, XLXS or ODS.',
            'sample' => 'You can download a sample spreadsheet here (:sample).',
        ],
        'switch' => [
            'toggle' => 'Toggle setting',
        ],
        'tabs' => [
            'select' => 'Select a tab',
        ],
        'api_token' => [
            'create' => [
                'title' => 'Create API Token',
                'description' => 'API tokens allow third-party services to authenticate with our application on your behalf.',
            ],
            'manage' => [
                'title' => 'Manage API Tokens',
                'description' => 'You may delete any of your existing tokens if they are no longer needed.',
                'last_used' => 'Last Used :time',
            ],
            'display' => [
                'title' => 'API Token',
                'description' => 'Please copy your new API token. For your security, it won\'t be shown again.',
            ],
            'permissions' => [
                'title' => 'API Token Permissions',
            ],
            'delete' => [
                'title' => 'Delete API Token',
                'description' => 'Are you sure you would like to delete this API token?',
            ],
        ],
        'secure_area' => [
            'description' => 'This is a secure area of the application. Please confirm your password before continuing.',
        ],
        'forgot_password' => [
            'description' => 'Forgot your password? No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one.',
        ],
        'login' => [
            'forgot_password' => 'Forget Your Password?',
        ],
        'register' => [
            'already_registered' => 'Already registered?',
        ],
        'two_factor_confirmation' => [
            'code' => 'Please confirm access to your account by entering the authentication code provided by your authenticator application.',
            'recovery' => 'Please confirm access to your account by entering one of your emergency recovery codes.',
        ],
        'email_verification' => [
            'description' => 'Before continuing, could you verify your email address by clicking on the link we just emailed to you? If you didn\'t receive the email, we will gladly send you another.',
            'link' => 'A new verification link has been sent to the email address you provided in your profile settings.',
            'edit_profile' => 'Edit Profile',
        ],
        'profile' => [
            'delete' => [
                'title' => 'Delete Account',
                'description' => 'Permanently delete your account.',
                'warning' => 'Once your account is deleted, all of its resources and data will be permanently deleted. Before deleting your account, please download any data or information that you wish to retain.',
                'confirmation' => 'Are you sure you want to delete your account? Once your account is deleted, all of its resources and data will be permanently deleted. Please enter your password to confirm you would like to permanently delete your account.',
            ],
            'browser_sessions' => [
                'title' => 'Browser Sessions',
                'description' => 'Manage and log out your active sessions on other browsers and devices.',
                'warning' => 'If necessary, you may log out of all of your other browser sessions across all of your devices. Some of your recent sessions are listed below; however, this list may not be exhaustive. If you feel your account has been compromised, you should also update your password.',
                'this_device' => 'This device',
                'last_active' => 'Last active :time',
                'logout' => 'Log Out Other Browser Sessions',
                'logout_confirmation' => 'Please enter your password to confirm you would like to log out of your other browser sessions across all of your devices.',
            ],
            '2fa' => [
                'title' => 'Two Factor Authentication',
                'description' => 'Add additional security to your account using two factor authentication.',
                'enabled' => 'You have enabled two factor authentication.',
                'confirming' => 'Finish enabling two factor authentication.',
                'not_enabled' => 'You have not enabled two factor authentication.',
                'info' => 'When two factor authentication is enabled, you will be prompted for a secure, random token during authentication. You may retrieve this token from your phone\'s Google Authenticator application.',
                'confirm' => 'To finish enabling two factor authentication, scan the following QR code using your phone\'s authenticator application or enter the setup key and provide the generated OTP code.',
                'scan' => 'Two factor authentication is now enabled. Scan the following QR code using your phone\'s authenticator application or enter the setup key.',
                'setup_key' => 'Setup Key:',
                'recovery' => 'Store these recovery codes in a secure password manager. They can be used to recover access to your account if your two factor authentication device is lost.',
            ],
            'update_password' => [
                'title' => 'Update Password',
                'description' => 'Ensure your account is using a long, random password to stay secure.',
            ],
            'information' => [
                'title' => 'Profile Information',
                'description' => 'Update your account\'s profile information and email address.',
                'email_unverified' => 'Your email address is unverified.',
                'resend_verification_email' => 'Click here to re-send the verification email.',
                'new_verification_link' => 'A new verification link has been sent to your email address.',
            ]
        ],
        'installation' => [
            'title' => 'Installation',
            'description' => 'Please complete all the steps to finish the installation.',
            'requirements' => 'Requirements',
            'permissions' => 'Permissions',
            'database' => 'Database',
            'admin' => 'Admin',
            'completed' => 'Completed',
            'cron_instructions' => 'Schedule a cron job running per minute with following command. It is necessary to do this otherwise app may not work properly.'
        ],
        'invoice' => [
            'title' => 'Invoice #:id',
            'thank_you' => 'Thank you!',
            'footer' => 'If you have any questions concerning this invoice, feel free to contact us.'
        ],
        'home' => [
            'tagline' => 'Use your Android device as SMS and MMS Gateway',
            'open_main_menu' => 'Open main menu',
            'close_menu' => 'Close menu',
            'get_started' => 'Get Started',
            'learn_more' => 'Learn more',
            'sections' => 'Sections',
            'support' => 'Support',
            'legal' => 'Legal',
            'contact' => 'Contact',
            'documentation' => 'Documentation',
            'tos' => 'Terms of service',
            'privacy_policy' => 'Privacy policy',
            'developers' => 'Developers',
            'features' => [
                'title' => 'Features',
                'tagline' => 'Innovative Tools for Better Communication',
                'description' => 'Delivering powerful, user-friendly features to optimize your messaging experience.',
                1 => [
                    'title' => 'Contact List',
                    'description' => 'Customize your contact list with new fields, set defaults, and use them in messages. Includes easy subscribe and unsubscribe options for contacts for seamless management.',
                ],
                2 => [
                    'title' => 'Auto Responder',
                    'description' => 'Set up automated responses based on specific patterns, keywords, or message content, ensuring timely and relevant replies without manual intervention.',
                ],
                3 => [
                    'title' => 'API & Webhooks',
                    'description' => 'Securely integrate with your apps using API tokens and configure multiple webhooks for different events, enabling seamless automation and real-time updates.',
                ],
                4 => [
                    'title' => 'Sending Servers',
                    'description' => 'Add and manage your own third-party SMS gateways with ease. Supports Twilio and Textlocal out of the box, with the flexibility to integrate additional gateways by configuring their API from the UI.'
                ],
                5 => [
                    'title' => 'USSD',
                    'description' => 'Leverage Android device SIMs to send USSD pull requests, with support for multiple requests per campaign. Easily create webhooks to receive real-time responses in your app, enabling dynamic interaction and data retrieval.',
                ],
                6 => [
                    'title' => 'Quota',
                    'description' => 'Manage message limits with quota settings for Android SIMs and Sending Servers. Each campaign follows the specified quota, automatically pausing when the limit is reached and resuming once the quota resets.',
                ],
                7 => [
                    'title' => 'Call Log',
                    'description' => 'Access detailed call logs for each SIM directly from the web panel, with options to set up webhooks for real-time response to incoming calls. Monitor and manage call activity seamlessly.',
                ],
                8 => [
                    'title' => 'Campaign',
                    'description' => 'Customize your campaigns to run on specific days and within a designated time frame. Campaigns automatically pause outside of these and resume when allowed. You can also create scheduled and recurring campaigns.'
                ]
            ],
            'faqs' => [
                'title' => 'FAQs',
                'description' => 'Frequently asked questions',
                1 => [
                    'question' => 'How does it work?',
                    'answer' => 'Our SMS Gateway app acts as a bridge between your device and server. Simply install the app on your device, login to app using your credentials and you will be able to start using the platform.'
                ],
                2 => [
                    'question' => 'Can I send SMS for free when using the service?',
                    'answer' => 'No, each SMS will use up credits, and each plan comes with a specific number of credits. Additionally, it depends on the carrier plan linked to your SIM, as carrier fees may apply based on your plan.'
                ],
                3 => [
                    'question' => 'Can I send MMS even if it is not supported?',
                    'answer' => 'No, MMS must be supported by your carrier to send and receive messages. It should not be confused with RCS or other internet-based messaging services like MI Messaging.'
                ],
                4 => [
                    'question' => 'Does it require a credit card for the trial?',
                    'answer' => 'No credit card is needed for the trial. Simply create an account to get started.'
                ],
                5 => [
                    'question' => 'Can I cancel my subscription at any time?',
                    'answer' => 'Yes, you can cancel your subscription at any time. After cancellation, you\'ll still have access for the remainder of your current term, but it won\'t renew for the next term.'
                ]
            ],
            'footer' => [
                'title' => 'Boost your productivity. Start using our app today.',
                'tagline' => 'Transform the way you communicate with simple, powerful tools.',
            ]
        ],
        'unsubscribed' => [
            'title' => 'Unsubscribed',
            'description' => 'Your number has been successfully unsubscribed from the contact list. Let us know if you change your mind.'
        ],
        'dashboard' => [
            'section' => [
                'campaigns' => 'Campaigns',
                'messages' => 'Messages',
                'calls' => 'Calls',
                'ussd_pulls' => 'USSD Pulls',
                'misc' => 'Miscellaneous',
            ],
            'credits_usage_summary' => 'How Credits Are Used?',
            'welcome' => [
                'title' => 'Welcome',
                'description' => 'Follow the steps below to start using the app.',
                'messages' => [
                    'title' => 'Messages',
                    'description' => 'You can send SMS, MMS using your Android device or third party services like Twilio, Textlocal etc. WhatsApp messages can be sent by adding a custom gateway to the system.',
                ],
                'ussd_pulls' => [
                    'title' => 'USSD Pulls',
                    'description' => 'You need to add an Android device with Android 8 or above to the system in order to send USSD pull requests.',
                ],
                'send_android' => [
                    'title' => 'Send using an Android Device',
                    'description' => 'Just follow below steps to start sending campaigns using SIMs of your Android device.',
                    'step1' => 'Go to the Devices page by clicking the button below, click on Add button, and follow the on-screen instructions.',
                    'step2' => 'Once a device is added, you can use its SIMs to send messages or USSD pull requests.',
                ],
                'send_custom_gateway' => [
                    'title' => 'Send using a Custom Gateway',
                    'description' => 'Just follow below steps to start sending messages using third party services like Twilio, Textlocal etc.',
                    'step1' => 'Check the documentation for the necessary configuration details for your chosen gateway.',
                    'step2' => 'Visit the Sending Servers page using the button below, click on Add button, select your preferred gateway, and enter the required configuration values.',
                    'step3' => 'After setting up a sending server, you’ll need to add a Sender ID. You can do this by going to Sender IDs page by clicking the following button and clicking Add button on that page.',
                    'step4' => 'Once  a Sender ID is added, you can use it to send messages.',
                ],
            ],
        ],
        'updated' => [
            'title' => 'Updated',
            'description' => 'The system has been updated to the new version successfully.',
        ],
        'alert' => 'Alert',
        'announcement' => 'Announcement',
        'inclusive' => 'Inclusive',
        'exclusive' => 'Exclusive',
        'unknown' => 'Unknown',
        'done' => 'Done.',
        'created' => 'Created.',
        'saved' => 'Saved.',
        'view_all' => 'View All',
        'stats' => 'stats',
        'tos' => 'Terms of Service',
        'privacy_policy' => 'Privacy Policy',
        'close_sidebar' => 'Close sidebar',
        'open_sidebar' => 'Open sidebar',
        'view_notifications' => 'View notifications',
        'user_menu' => 'Open user menu for ',
        'mobile_number_per_line' => 'Enter a mobile number per line.',
        'email_per_line' => 'Enter an email address per line.',
        'element_not_supported' => 'Your browser does not support this element.',
        'pagination' => 'Showing <strong>:from</strong> to <strong>:to</strong> of <strong>:total</strong> results',
        'file_selected' => 'A file selected|:count files selected',
    ],
];
