<?php
/*
 * Copyright © 2018-2025 RBSoft (Ravi Patel). All rights reserved.
 *
 * Author: Ravi Patel
 * Website: https://rbsoft.org/downloads/sms-gateway
 *
 * This software is licensed, not sold. Buyers are granted a limited, non-transferable license
 * to use this software exclusively on a single domain, subdomain, or computer. Usage on
 * multiple domains, subdomains, or computers requires the purchase of additional licenses.
 *
 * Redistribution, resale, sublicensing, or sharing of the source code, in whole or in part,
 * is strictly prohibited. Modification (except for personal use by the licensee), reverse engineering,
 * or creating derivative works based on this software is strictly prohibited.
 *
 * Unauthorized use, reproduction, or distribution of this software may result in severe civil
 * and criminal penalties and will be prosecuted to the fullest extent of the law.
 *
 * For licensing inquiries or support, please visit https://support.rbsoft.org.
 */

namespace App\Jobs;

use App\Models\Campaign;
use App\Monitor;

class ProcessManualCampaign extends ProcessCampaign
{
    protected Campaign $campaign;

    private Monitor $monitor;

    /**
     * Create a new job instance.
     */
    public function __construct(Campaign $campaign)
    {
        $this->campaign = $campaign;
        $this->monitor = Monitor::for(Campaign::class, $this->campaign->id);
        $this->monitor->total = count($this->campaign->payload->get('mobile_numbers', []));
        $this->monitor->processed = $this->monitor->failures = 0;
    }

    public function process(): void
    {
        $mobile_numbers = collect($this->campaign->payload->get('mobile_numbers', []));
        $senderCount = $this->campaign->senders->count();

        $proccessed = 0;
        foreach ($mobile_numbers as $mobileNumber) {
            if ($this->monitor->cancelled) {
                $this->job->delete();
                break;
            }

            $allowed =
                $this->campaign->options->get('force', false) ||
                $this->campaign->user->blacklist()
                                     ->whereMobileNumber($mobileNumber)
                                     ->doesntExist();

            if ($allowed) {
                $senderIndex = $senderCount > 0 ? $proccessed % $senderCount : 0;
                $sender = $this->campaign->senders->get($senderIndex);
                $this->campaign->addMessage($mobileNumber, $sender);
                $proccessed++;
            }

            $this->monitor->processed++;
        }
    }
}
