<?php

namespace App\Http\Requests;

use App\Models\Subscription;
use Illuminate\Container\Attributes\RouteParameter;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class UpdateSubscriptionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(#[RouteParameter('subscription')] Subscription $subscription): bool
    {
        return Gate::allows('update', $subscription);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'features' => ['required', 'array'],
            'features.credits' => ['nullable', 'numeric', 'min:0'],
        ];
    }
}
